
import cadquery as cq

# Define dimensions for the table
table_length = 10.0
table_width = 4.0
table_height = 1.0
column_width = 2.0  # This is made wider to fulfill feedback requirement
column_height = 4.0

# Create tabletop which will be the broad flat surface when flipped upside down
table_top = cq.Workplane("XY").box(table_length, table_width, table_height)

# Create columns (legs) for "U" shaped structure
# Increase width of columns while keeping their height unchanged
column1 = (
    cq.Workplane("XY")
    .workplane(offset=-column_height)
    .moveTo(-table_length / 2 + column_width / 2, -table_width / 2 + column_width / 2)
    .box(column_width, column_width, column_height)
)

column2 = (
    cq.Workplane("XY")
    .workplane(offset=-column_height)
    .moveTo(table_length / 2 - column_width / 2, -table_width / 2 + column_width / 2)
    .box(column_width, column_width, column_height)
)

column3 = (
    cq.Workplane("XY")
    .workplane(offset=-column_height)
    .moveTo(-table_length / 2 + column_width / 2, table_width / 2 - column_width / 2)
    .box(column_width, column_width, column_height)
)

column4 = (
    cq.Workplane("XY")
    .workplane(offset=-column_height)
    .moveTo(table_length / 2 - column_width / 2, table_width / 2 - column_width / 2)
    .box(column_width, column_width, column_height)
)

# Union tabletop and all columns to make an inverted table
result = table_top.union(column1).union(column2).union(column3).union(column4)

# Rotate the table to make it appear upside-down
result = result.rotate((0, 0, 0), (1, 0, 0), 180)

# Export the final model
result.val().exportStl("Refine_V_1.stl")
