
import cadquery as cq

# Define the dimensions for the trapezoid
bottom_length = 10.0
top_length = 6.0
height = 8.0
thickness = 2.0

# Define the dimensions for the trapezoidal hole
hole_bottom_length = 8.0
hole_top_length = 4.0
hole_height = 6.0
hole_vertical_offset = (height - hole_height) / 2
hole_horizontal_offset = (bottom_length - hole_bottom_length) / 2

# Create the trapezoid
trapezoid = (
    cq.Workplane("front")
    .lineTo(bottom_length / 2, 0)
    .lineTo(top_length / 2, height)
    .lineTo(-top_length / 2, height)
    .lineTo(-bottom_length / 2, 0)
    .close()
    .extrude(thickness)
)

# Create the trapezoidal hole
hole = (
    cq.Workplane("front")
    .moveTo(hole_bottom_length / 2 - hole_horizontal_offset, hole_vertical_offset)
    .lineTo(hole_bottom_length / 2, hole_vertical_offset)
    .lineTo(hole_top_length / 2, hole_vertical_offset + hole_height)
    .lineTo(-hole_top_length / 2, hole_vertical_offset + hole_height)
    .lineTo(-hole_bottom_length / 2, hole_vertical_offset)
    .close()
    .extrude(thickness)
)

# Make a cut to create the hole
result = trapezoid.cut(hole)

# Export the model into an STL file
result.val().exportStl("Refine_V_1.stl")
