
import cadquery as cq
import math

# Original dimensions
base1 = 10.0  # Shorter parallel side
base2 = 20.0  # Longer parallel side
height = 15.0  # Height of the trapezium
thickness = 5.0  # Thickness of extrusion

# Calculate the leg's length which should be equal for a regular trapezium
leg_length = math.sqrt((height**2) + ((base2 - base1)/2.0)**2)

# Create the trapezium sketch
result = (
    cq.Workplane("front")
    .moveTo(-base2 / 2.0, 0)
    .lineTo(-base1 / 2.0, height)
    .lineTo(base1 / 2.0, height)
    .lineTo(base2 / 2.0, 0)
    .close()
)

# Extrude the sketch to form a prism
result = result.extrude(thickness)

# Save the result to an STL file
result.val().exportStl("Refine_V_1.stl")
