
import cadquery as cq

# Create a rectangle and extrude it to form the base shape
r = cq.Workplane("front").rect(10, 5)
r = r.extrude(2)

# Fillet the corners on the same long edge of the rectangle
r = r.edges("|Z and >X").fillet(1)
r = r.edges("|Z and <X").fillet(1)

# Position the holes closer to the rounded corners
# Noting that the original X positions were -4 and 4, adjusted the positioning slightly closer to corners
x_pos = 3.5  # Using a lower absolute value for x, closer to the filleted corners
hole_distance_from_edge = 0.75  # Distance from the outer filleted edge (tuned based on visual suitability)
r = r.faces(">Z").workplane().pushPoints([(-x_pos, hole_distance_from_edge), (x_pos, hole_distance_from_edge)]).hole(0.5)

# Export the modified model to a new STL file
r.val().exportStl("Refine_V_2.stl")
