
import cadquery as cq

# Parameters adjusted based on feedback
horizontal_length = 1   # Smaller horizontal section
vertical_length = 15
thickness = 2
curve_radius = 0.5

result = (cq.Workplane("front")
          .moveTo(0, 0)
          .lineTo(0, curve_radius)
          .threePointArc((curve_radius, curve_radius + curve_radius), (2 * curve_radius, curve_radius))
          .lineTo(thickness + curve_radius, curve_radius)
          .lineTo(thickness, 0)
          .lineTo(thickness, vertical_length - horizontal_length - curve_radius)
          # ThreePointArc modified to introduce a slight curve in the vertical section
          .threePointArc((thickness - curve_radius/2, vertical_length - horizontal_length + curve_radius/2),
                          (thickness - curve_radius, vertical_length - horizontal_length))
          .lineTo(0, vertical_length - horizontal_length - curve_radius)
          .close()
          .moveTo(thickness, vertical_length - horizontal_length)
          .lineTo(thickness + horizontal_length, vertical_length - horizontal_length)
          .lineTo(thickness + horizontal_length, vertical_length)
          .lineTo(thickness, vertical_length)
          .close()
          .extrude(1)
         )

result.val().exportStl("Refine_V_2.stl")
