
import cadquery as cq

# Create a rectangular block
block = cq.Workplane("XY").rect(10, 20).extrude(5)

# Create a semi-circular cutout
cutout = (
    block.faces(">Z")
    .workplane()
    .center(0, 5)  # Center of the semi-circle
    .split(keepTop=True)
    .circle(5)  # Radius of the semi-circle
    .extrude(-2)  # Depth of the cutout
)

# Export the result
cutout.val().exportStl("Generated.stl")
