
import cadquery as cq

# Create the base rectangle block
block = cq.Workplane("XY").rect(20, 10).extrude(5)

# Parameters for the semi-circle
radius = 5
width = 20
extrude_depth = 5

# Create a semi-circle cutout
cutout = (
    block.faces(">Z")  # Select the top face of the block
    .workplane(centerOption="CenterOfBoundBox")
    .moveTo(width / 2 - radius, 0)
    .radiusArc((width / 2 + radius, 0), -radius)  # Create semi-circle
    .lineTo(width / 2 - radius, 0)
    .close()
    .extrude(-extrude_depth, combine=True)  # Negatively extrude the semi-circle cutout
)

# Save the result to STL
cutout.val().exportStl("Refine_V_2.stl")
