
import cadquery as cq

# Define dimensions
rect_length = 30.0
rect_width = 10.0
semi_hex_length = rect_length * 2 / 3
semi_hex_height = rect_width / 2

# Create a rectangle and semi-hexagonal sketch
result = cq.Workplane("front")

# The rectangle
result = result.rect(rect_length, rect_width)

# The semi-hexagon parameters
# Points are calculated relative to the rectangle's right edge
start_x = rect_length / 2  # Center the semi-hexagon on the right edge of the rectangle
points = [
    (start_x, 0), 
    (start_x + semi_hex_length, 0),
    (start_x + semi_hex_length - (semi_hex_length / 4), semi_hex_height),
    (start_x + (semi_hex_length / 4), semi_hex_height),
    (start_x, 0)
]

# Draw the semi-hexagonal section
result = result.polyline(points).close()

# Extrude the sketch
result = result.extrude(rect_width)

# Export the result as STL file
result.val().exportStl("Refine_V_1.stl")
