
import cadquery as cq

# Parameters initialization
rect_length = 30.0
rect_width = 10.0
semi_hex_length = rect_length * 2 / 3
semi_hex_depth = rect_width  # Using rect_width as a depth for consistent extrusion

# Create a base Workplane
result = cq.Workplane("front")

# Create a rectangle on the workplane
result = result.rect(rect_length, rect_width)

# Start the semi-hexagonal section using a polygon with calculated coordinates
semi_hex_points = [
    (rect_length / 2, -rect_width / 2),  # Start at the end of the rectangle
    (rect_length / 2 + semi_hex_length, -rect_width / 2),  # Move right on the bottom edge
    (rect_length / 2 + semi_hex_length - semi_hex_length / 6, rect_width / 2),  # Up to the middle top of the semi-hexagon
    (rect_length / 2 + semi_hex_length / 6, rect_width / 2),  # Move left at the top edge
    (rect_length / 2, -rect_width / 2)  # back to the start
]
result = result.polyline(semi_hex_points).close()  # Close the polyline to form a closed shape

# Extrude the resultant sketch to form a solid body
result = result.extrude(semi_hex_depth)

# Save the final result as an STL file
result.val().exportStl("Refine_V_2.stl")
