
import cadquery as cq

# Creating the base shape of two overlapping circles.
result = cq.Workplane("XY").circle(10.0).translate((5, 0)).circle(10.0).translate((-5, 0)).extrude(1)

# Creating cutouts with two smaller overlapping circles centered at the same point as the original circles.
cutout = cq.Workplane("XY").circle(5.0).translate((2.5, 0)).circle(5.0).translate((-2.5, 0)).extrude(1)

# Cutting the holes out of the original solid
result = result.cut(cutout)

# Exporting the final model to an STL file
result.val().exportStl("Refine_V_2.stl")
