
import cadquery as cq

# Parameters
main_square_side = 10.0
rectangle_width = 1.0
rectangle_height = 2.0 * rectangle_width  # Ensure height is twice the width
extrude_depth = 0.5

# Main square
result = cq.Workplane("front").rect(main_square_side, main_square_side)

# Adding rectangles on the left and right edges of the square
# Positioning is moved so that the rectangles are on the very edges
result = result.rect(rectangle_width, rectangle_height).translate((-main_square_side/2 - rectangle_width/2, 0))
result = result.rect(rectangle_width, rectangle_height).translate((main_square_side/2 + rectangle_width/2, 0))

# Extrude the sketch
result = result.extrude(extrude_depth)

# Output
result.val().exportStl("Refine_V_1.stl")
