
import cadquery as cq

# Parameters definition
main_square_side = 10.0
rectangle_width = 1.0
rectangle_height = 2.0 * rectangle_width  # Ensure the height is twice the width
extrude_depth = 0.5  # Small depth confirmed

# Creating the main square
result = cq.Workplane("front").rect(main_square_side, main_square_side)

# Positioning first rectangle on the left, along the horizontal center line of the square
left_rect_position = (-main_square_side/2 + rectangle_width/2, 0)
result = result.rect(rectangle_width, rectangle_height).translate(left_rect_position)

# Positioning second rectangle on the right, along the horizontal center line of the square
right_rect_position = (main_square_side/2 - rectangle_width/2, 0)
result = result.rect(rectangle_width, rectangle_height).translate(right_rect_position)

# Combining and extruding the sketch
result = result.extrude(extrude_depth)

# Saving output
result.val().exportStl("Refine_V_2.stl")
