
import cadquery as cq

length = 100.0
width = 20.0
thickness = 2.0
cutout_length = length / 4.0
cutout_width = width / 2.0

# Creating the basic rectangle and extruding it
result = (
    cq.Workplane("XY")
    .rect(length, width)
    .extrude(thickness)
)

# Adding the cutout at the bottom right of the rectangle
cutout_position_x = length / 2 - cutout_length / 2  # Center of the cutout in the X axis
cutout_position_y = -width / 2 + cutout_width / 2  # Close to the bottom side in the Y axis

result = (
    result.faces(">Z")
    .workplane(centerOption="CenterOfMass")
    .rect(cutout_length, cutout_width)
    .translate((cutout_position_x, cutout_position_y, 0))
    .cutThruAll()
)

# Export the final result to STL
result.val().exportStl("Refine_V_1.stl")
