
import cadquery as cq

# Define the 3D extrusion height
height = 5

# Create the base rectangle and extrude it
base = cq.Workplane("XY").rect(10, 20).extrude(height)

# Create the smaller rectangles and extrude them
small_rect1 = cq.Workplane("XY").transformed(offset=(5, 5)).rect(5, 10).extrude(height)
small_rect2 = cq.Workplane("XY").transformed(offset=(-5, 5)).rect(5, 10).extrude(height)

# Combine the shapes
result = base.union(small_rect1).union(small_rect2)

# Create the hole
result = result.faces(">Z").workplane().hole(5)

# Export the result
result.val().exportStl("Generated.stl")
