
import cadquery as cq

# Defining dimensions
length = 100.0  # Overall length of the wrench
width = 10.0  # Width of the wrench handle
thickness = 5.0  # Thickness of the wrench
small_radius = 15.0  # Radius for the smaller circle end
large_radius = 20.0  # Radius for the larger circle end
small_hole_radius = 7.0  # Radius for the inner hole of the smaller circle
large_hole_radius = 10.0  # Radius for the inner hole of the larger circle
handle_length = length - small_radius - large_radius

# Creating the base shape
result = cq.Workplane("XY").lineTo(-large_radius, 0)\
    .lineTo(-large_radius, width/2)\
    .lineTo(-(large_radius + handle_length / 2), width/2)\
    .lineTo(-handle_length / 2 - large_radius, -width/2)\
    .lineTo(-large_radius, -width/2)\
    .lineTo(-large_radius, 0)\
    .threePointArc((0, small_radius), (large_radius, 0))\
    .lineTo(large_radius, width/2)\
    .lineTo(large_radius + handle_length / 2, width/2)\
    .lineTo(handle_length / 2 + large_radius, -width/2)\
    .lineTo(large_radius, -width/2)\
    .lineTo(large_radius, 0)\
    .close().extrude(thickness)

# Creating holes in the circular ends
result = result.faces(">Z").workplane()\
    .pushPoints([(-length / 2 + large_radius, 0), (length / 2 - small_radius, 0)])\
    .hole(large_hole_radius * 2)\
    .hole(small_hole_radius * 2)

# Exporting as STL
result.val().exportStl("Refine_V_1.stl")
