
import cadquery as cq

# Define the dimensions
length = 100.0
width = 50.0
thickness = 10.0
hole_diameter = 5.0
hole_spacing = 15.0  # the spacing between the holes

# Create the main rectangular block
result = (
    cq.Workplane("XY")
    .box(length, width, thickness)
)

# Adding three holes
result = (
    result.faces(">Z")
    .workplane()
    .center(length / 4, width / 2 - hole_spacing)  # position first hole
    .hole(hole_diameter)
    .center(0, -hole_spacing)  # position second hole, right below the first
    .hole(hole_diameter)
    .center(0, -hole_spacing)  # position third hole, right below the second
    .hole(hole_diameter)
)

# Save the result as an STL file
result.val().exportStl("Refine_V_2.stl")
