
import cadquery as cq

# Define the parameters for the bucket
bucket_height = 10.0
bucket_radius = 5.0
bucket_thickness = 0.5
handle_diameter = 0.5
handle_length = 2 * bucket_radius + 2.0

# Create the outer shell of the bucket
bucket = cq.Workplane("XY") \
    .circle(bucket_radius) \
    .extrude(bucket_height)

# Create the inner hollow of the bucket by cutting, ensure it does not go all the way through
inner_depth = bucket_height - 1.0  # This will leave 1mm at the bottom uncut
bucket = bucket.faces(">Z") \
    .workplane() \
    .circle(bucket_radius - bucket_thickness) \
    .cutBlind(-inner_depth)

# Create and position the handle over the top of the bucket
handle = cq.Workplane("YZ") \
    .workplane(offset=bucket_radius + handle_diameter / 2) \
    .transformed(offset=(0, 0, bucket_height - bucket_thickness/2), rotate=(90, 0, 0)) \
    .circle(handle_diameter / 2) \
    .extrude(handle_length)

# Combine the bucket and the handle into a single solid
result = bucket.union(handle)

# Export the model to an STL file
result.val().exportStl("Refine_V_1.stl")
