
import cadquery as cq

# Define dimensions for the base and slot
base_length = 10
base_width = 10
base_height = 5

slot_length = 5
slot_width = 5
slot_depth = 3

# Create the main rectangular base
base = cq.Workplane("XY").rect(base_length, base_width).extrude(base_height)

# Create a centered slot by negatively extruding a smaller rectangle
slot = base.faces(">Z").workplane().rect(slot_length, slot_width).cutBlind(-slot_depth)

# Output the final shape to an STL file
slot.val().exportStl("Refine_V_1.stl")
