
import cadquery as cq

# Define dimensions
rect_width = 10.0
rect_height = 5.0
tri_height = 5.0
cutout_size = 1.0
extrude_amount = 1.0

# Create a workplane
result = cq.Workplane("front")

# Create rectangle
result = result.rect(rect_width, rect_height)

# Adding the isosceles triangle on top of rectangle
result = result.moveTo(0, rect_height / 2.0).lineTo(rect_width / 2.0, rect_height / 2.0 + tri_height).lineTo(-rect_width / 2.0, rect_height / 2.0 + tri_height).close()

# Cut out small triangles from the bottom-left and bottom-right corners
# Bottom-left corner cutout
result = result.moveTo(-rect_width / 2.0, -rect_height / 2.0)
result = result.polyline([(-rect_width / 2.0 + cutout_size, -rect_height / 2.0), (-rect_width / 2.0, -rect_height / 2.0 + cutout_size), (-rect_width / 2.0, -rect_height / 2.0)]).close()

# Bottom-right corner cutout
result = result.moveTo(rect_width / 2.0, -rect_height / 2.0)
result = result.polyline([(rect_width / 2.0 - cutout_size, -rect_height / 2.0), (rect_width / 2.0, -rect_height / 2.0 + cutout_size), (rect_width / 2.0, -rect_height / 2.0)]).close()

# Extrude the sketch to create a 3D object
result = result.extrude(extrude_amount)

# Export to STL
result.val().exportStl("Refine_V_1.stl")
