
import cadquery as cq

table_length = 100.0
table_width = 60.0
table_thickness = 5.0
leg_length = 20.0
leg_width = 10.0
leg_height = 50.0

table = cq.Workplane("XY").box(table_length, table_width, table_thickness)

# Adjusting leg placement to be at each end of the table_base.
leg1 = (
    cq.Workplane("XY")
    .workplane(offset=table_thickness)
    .moveTo(-table_length / 2 + leg_length / 2, -table_width / 2 + leg_width / 2)
    .rect(leg_length, leg_width)
    .extrude(leg_height)
)

leg2 = (
    cq.Workplane("XY")
    .workplane(offset=table_thickness)
    .moveTo(table_length / 2 - leg_length / 2, -table_width / 2 + leg_width / 2)
    .rect(leg_length, leg_width)
    .extrude(leg_height)
)

result = table.union(leg1).union(leg2)

result.val().exportStl("Refine_V_2.stl")
