
import cadquery as cq

# Parameters defining the dimensions of the thermometer
circle_diameter = 10.0
rectangle_width = 1.0
rectangle_height = 7.0 * rectangle_width  # Height is 7 times the width
hole_diameter = 0.5
extrude_depth = 2.0

# Create a new workplane to start the sketch
result = cq.Workplane("front")

# Creating the base circle
result = result.circle(circle_diameter / 2.0)

# Moving to the top of the circle to start the rectangle
rectangle_placement_y = -circle_diameter / 2.0
result = result.workplane(offset=0) \
    .transformed(offset=(0, rectangle_placement_y, 0)) \
    .rect(rectangle_width, rectangle_height, centered=False) \
    .extrude(extrude_depth)

# Adding a hole near the top of the rectangle
hole_placement_y = rectangle_placement_y - (rectangle_height - hole_diameter)
result = result.workplane(offset=0) \
    .transformed(offset=(0, hole_placement_y, 0)) \
    .circle(hole_diameter / 2.0) \
    .cutThruAll()

# Return solid model and export as STL
result = result.combineSolids()
result.val().exportStl("Refine_V_2.stl")
