
import cadquery as cq

# Parameters
length = 80
width = 20
thickness = 5
cutout_side = 10
cutout_fillet_radius = 2

# Create the main rectangular plate
plate = cq.Workplane("XY").box(length, width, thickness)

# Create cutout 1 at the first corner
cutout1 = (
    cq.Workplane("XY", origin=(cutout_side/2, cutout_side/2, thickness))
    .rect(cutout_side, cutout_side)
    .extrude(-thickness)
    .edges("|Z")
    .fillet(cutout_fillet_radius)
)

# Create cutout 2 at the diagonally opposite corner, along the longer edge
cutout2 = (
    cq.Workplane("XY", origin=(length - cutout_side/2, cutout_side/2, thickness))
    .rect(cutout_side, cutout_side)
    .extrude(-thickness)
    .edges("|Z")
    .fillet(cutout_fillet_radius)
)

# Cut the cutouts from the plate
result = plate.cut(cutout1).cut(cutout2)

# Export the result
result.val().exportStl("Refine_V_1.stl")
