
import cadquery as cq

# Defined parameters
base_length = 10.0
height = 15.0
corner_radius = 1.0
hole_radius = 0.3
cut_height = 12.0  # The height at which the top corner is cut

# Create an isosceles triangle
triangle = (
    cq.Workplane("XY")
    .moveTo(-base_length / 2, 0)
    .lineTo(base_length / 2, 0)
    .lineTo(0, height)
    .close()
)

# Positioning to apply the cutoff top, creates a line to cut off the top of the triangle
triangle = (
    triangle
    .moveTo(0, cut_height)
    .lineTo(base_length / 2, cut_height)
    .lineTo(-base_length / 2, cut_height)
    .close()
)

# Create the main body by extruding the sketch
result = triangle.extrude(1.0)

# Apply fillets to the two bottom corners
result = result.edges("|Z").fillet(corner_radius)

# Locate three points where the holes will be
hole_positions = [(-base_length / 3, cut_height / 3), (base_length / 3, cut_height / 3), (0, 2 * cut_height / 3)]

# Drill holes at defined positions
for pos in hole_positions:
    result = result.faces(">Z").workplane().pushPoints([pos]).hole(hole_radius)

# Export the result as an STL file
result.val().exportStl("Refine_V_1.stl")
