
import cadquery as cq
import math

# Specifications
base_length = 10.0
top_length = 5.0
height = 7.0
extrude_amount = 2.0

# Calculate the base angle of 70 degrees to radians
base_angle_deg = 70
base_angle = math.radians(base_angle_deg)

# Calculate the length of the side (finding half height using tangent of half of base angle)
half_base = base_length / 2
half_top = top_length / 2
side_height = height / 2 / math.tan(base_angle / 2) # half-height / tan(35 degrees)

# Coordinates based on calculated points
x1 = -half_base
y1 = -side_height
x2 = -half_top
y2 = side_height
x3 = half_top
y3 = side_height
x4 = half_base
y4 = -side_height

# Create the trapezoid plate by drawing the points
result = (cq.Workplane("front")
          .moveTo(x1, y1)
          .lineTo(x2, y2)
          .lineTo(x3, y3)
          .lineTo(x4, y4)
          .close()  # Close the shape to form a loop
          .extrude(extrude_amount))

# Save the output as STL
result.val().exportStl("Refine_V_1.stl")
