
import cadquery as cq

# Create the first rectangle
first_rectangle = cq.Workplane("front").rect(17.5, 25.0).extrude(1.0)

# Create the second rectangle, starting halfway up the first one
second_rectangle = cq.Workplane("front").moveTo(17.5,12.5).rect(8.75, 12.5).extrude(1.0)

# Combine the two rectangles
result = first_rectangle.union(second_rectangle)

# Export the result
result.val().exportStl("Refine_2.stl")
