
import cadquery as cq

# Define the dimensions
length = 10.0
width = 5.0
height = 0.5

# Create the first rectangle
result = cq.Workplane("XY").box(length, width, height)

# Create the second rectangle perpendicular to the first one
result = result.faces(">Z").edges(">X").workplane().transformed(rotate=(0, 90, 0)).box(length, width, height)

# Export the result
result.val().exportStl("Refine_1.stl")
