
import cadquery as cq

# Define the dimensions of the main rectangle and the cut-out
main_length = 10.0
main_width = 5.0
main_height = 0.5
cutout_length = 4.0
cutout_width = 2.0
cutout_height = 0.5

# Create the main rectangle
result = cq.Workplane("XY").box(main_length, main_width, main_height)

# Create the cut-out
result = result.faces(">Z").workplane().center(main_length/2, main_width/2 + 0.1).rect(cutout_length, cutout_width).cutThruAll()

# Export the result
result.val().exportStl("Generated.stl")
