
import cadquery as cq

# Define the parameters of the annulus
outer_radius = 3.0
inner_radius = 1.5
thickness = 0.09

# Create the annulus
refined_result = (
    cq.Workplane("XY")
    .circle(outer_radius)
    .circle(inner_radius)
    .extrude(thickness)
)

# Export the refined result
refined_result.val().exportStl("Refine_2.stl")
