
import cadquery as cq

# Parameters for the cylinder
outer_radius = 20.0
inner_radius = 10.0
height = 40.0

# Create the outer cylinder
outer_cylinder = cq.Workplane("XY").circle(outer_radius).extrude(height)

# Create the inner cylinder
inner_cylinder = cq.Workplane("XY").circle(inner_radius).extrude(height)

# Subtract the inner cylinder from the outer cylinder
result = outer_cylinder.cut(inner_cylinder)

# Export the result
result.val().exportStl("Refine_2.stl")
