
import cadquery as cq

# Parameters for the ring
outer_radius = 1.5
inner_radius = 0.75
thickness = 0.01

# Create the ring
result = (
    cq.Workplane("XY")
    .circle(outer_radius)
    .circle(inner_radius)
    .extrude(thickness)
)

# Export the result to STL
result.val().exportStl("Refine_1.stl")
