
import cadquery as cq

# Define the dimensions of the rectangle and the holes
length = 1.5  # Length of the rectangle
width = 1.03  # Width of the rectangle
thickness = 0.17  # Thickness of the rectangle
hole_dia = 0.1  # Diameter of the holes
hole_offset = 0.2  # Distance from the corners to the center of the holes

# Create the rectangle
result = (
    cq.Workplane("XY")
    .box(length, width, thickness, centered=(True, True, False))
)

# Create the holes
for x in (-length / 2 + hole_offset, length / 2 - hole_offset):
    for y in (-width / 2 + hole_offset, width / 2 - hole_offset):
        result = result.faces(">Z").workplane().center(x, y).hole(hole_dia)

# Export the result
result.val().exportStl("Refine_2.stl")
