
import cadquery as cq

# Create a rectangle on a workplane and extrude it
# Dimensions of rectangle are 1.5mm x 1.5mm and extrusion height is 0.75mm
result = cq.Workplane("XY").rect(1.5, 1.5).extrude(0.75)

# Move the workplane down by half the extrusion height to center the bounding box at the origin
result = result.translate((0, 0, -0.375))

# Export the result to STL
result.val().exportStl("Refine_1.stl")
