
import cadquery as cq

# Define the square's side length and the extrusion height
side_length = 10.0
extrusion_height = 20.0

# Create a workplane, then a square, and then extrude it
result = (
    cq.Workplane("XY")
    .rect(side_length, side_length)
    .extrude(extrusion_height)
)

# Export the result to an STL file
result.val().exportStl("Generated.stl")
