
import cadquery as cq

# Define parameters for the square and extrusion
side_length = 0.03
extrusion_height = 0.75

# Create a workplane, then a square, and then extrude it
result = (
    cq.Workplane("XY")
    .rect(side_length, side_length, centered=False)
    .extrude(extrusion_height)
)

# Export the result to an STL file
result.val().exportStl("Refine_2.stl")
