
import cadquery as cq

# Adjust the dimensions of the table 
table_length = 1.5
table_width = 0.32
table_thickness = 0.54

# Adjust the dimensions of the legs
leg_length = table_length / 3.0
leg_width = table_width / 2.5
leg_thickness = table_thickness

# Create the table surface
table = cq.Workplane("XY").box(table_length, table_width, table_thickness)

# Create the legs
leg1 = (
    cq.Workplane("XY")
    .workplane(offset=-table_thickness)
    .moveTo(-table_length / 2.0 + leg_length / 2.0, 0)
    .box(leg_length, leg_width, leg_thickness)
)

leg2 = (
    cq.Workplane("XY")
    .workplane(offset=-table_thickness)
    .moveTo(table_length / 2.0 - leg_length / 2.0, 0)
    .box(leg_length, leg_width, leg_thickness)
)

# Combine the table and the legs
result = table.union(leg1).union(leg2)

# Export the result
result.val().exportStl("Refine_1.stl")
