
import cadquery as cq

# Define dimensions
rect_length = 30.0
rect_width = 10.0
rect_height = 5.0

small_square_side = 2.0
large_square_side = small_square_side * (1 / 0.25)**0.5  # Area is 75% smaller

small_square_height = 5.0
large_square_height = small_square_height * 2

# Create rectangle
result = cq.Workplane("XY").box(rect_length, rect_width, rect_height)

# Create small square
result = result.faces(">Y").workplane().moveTo(-rect_length/2, 0).box(small_square_side, small_square_side, small_square_height)

# Create large square
result = result.faces(">Y").workplane().moveTo(rect_length/2, 0).box(large_square_side, large_square_side, large_square_height)

# Export the result
result.val().exportStl("Refine_1.stl")
