
import cadquery as cq

# Define the dimensions
rect_length = 50.0
rect_width = 10.0
rect_height = 5.0
cylinder_radius = rect_width / 3
cylinder_height = rect_height * 2  # Make the cylinder twice as high as the rectangle

# Create the rectangle
result = cq.Workplane("XY").box(rect_length, rect_width, rect_height)

# Create the cylinder
result = result.faces(">Y").workplane().moveTo(-rect_length / 2, 0).circle(cylinder_radius).extrude(cylinder_height)

# Save the result
result.val().exportStl("Refine_1.stl")
