
import cadquery as cq

# Define the size of the cube
cube_size = 10.0

# Create the cube
cube = cq.Workplane("XY").box(cube_size, cube_size, cube_size)

# Define the size of the triangular prism
prism_size = cube_size / 4.0

# Create the triangular prism
prism = (
    cq.Workplane("XY")
    .moveTo(0, 0)
    .lineTo(prism_size, 0)
    .lineTo(0, prism_size)
    .close()
    .extrude(prism_size)
)

# Translate the prism to touch the cube
prism = prism.translate((cube_size - prism_size, 0, 0))

# Combine the cube and the prism
result = cube.union(prism)

# Export the result
result.val().exportStl("Refine_1.stl")
