
import cadquery as cq

# Define dimensions
rectangle_length = 15.0
rectangle_width = 10.0
rectangle_thickness = 0.5
rod_width = 1.0
rod_length = 1.0
rod_height = 3 * rectangle_length

# Create the base rectangle
result = (
    cq.Workplane("XY")
    .rect(rectangle_length, rectangle_width)
    .extrude(rectangle_thickness)
)

# Create the rod
result = (
    result
    .faces(">Z")
    .workplane()
    .rect(rod_length, rod_width)
    .extrude(rod_height)
)

# Export the result
result.val().exportStl("Generated.stl")
