
import cadquery as cq

# Create a rectangle and extrude it
result = cq.Workplane("XY").rect(0.47, 0.32).extrude(0.75)

# Create a circle positioned above the midpoint of the rectangle and negatively extrude it to create a hole
result = result.faces(">Z").workplane().center(0, -0.1578947454690932).circle(0.1).cutThruAll()

# Create a thin slit going through the rectangular block from the top of the circular hole to the shorter edge of the rectangle
result = result.faces(">Z").workplane().moveTo(0, -0.1578947454690932).rect(0.02, 0.16).cutThruAll()

# Save the output
result.val().exportStl("Refine_1.stl")
