
import cadquery as cq

# Create a square and extrude it to create a thin box
result = cq.Workplane("XY").rect(2.0, 2.0).extrude(0.03)

# Create a tiny rectangle in the center of the square and cut through
result = result.faces(">Z").workplane().rect(1.0, 1.0).cutThruAll()

# Save the output
result.val().exportStl("Refine_2.stl")
