
import cadquery as cq

# Parameters for the bike chain
large_diameter = 60.0
small_diameter = 20.0
separation = large_diameter

# Create the large circle
result = cq.Workplane("front").circle(large_diameter / 2)

# Move to the right and create the small circle
result = result.transformed(offset=(separation, 0, 0)).circle(small_diameter / 2)

# Draw the tangent lines
result = result.moveTo(0, large_diameter / 2).lineTo(separation, small_diameter / 2)
result = result.lineTo(separation, -small_diameter / 2).lineTo(0, -large_diameter / 2)

# Close the sketch and extrude it
result = result.close().extrude(5.0)

# Save the output
result.val().exportStl("Refine_2.stl")
