
import cadquery as cq

# Define the dimensions of the outer and inner squares
outer_size = 0.23
inner_size = 0.21
extrusion_length = 0.75

# Create the outer square and extrude it
result = cq.Workplane("XZ").rect(outer_size, outer_size).extrude(extrusion_length)

# Create the inner square and extrude it negatively to create a hole
result = result.faces(">Y").workplane().rect(inner_size, inner_size).cutBlind(-extrusion_length)

# Export the result
result.val().exportStl("Refine_2.stl")
