
import cadquery as cq

# Create a cylinder
cylinder = cq.Workplane("XY").circle(10).extrude(20)

# Create a rectangular hole in the center of the cylinder
result = cylinder.faces(">Z").workplane().rect(5, 5).cutThruAll()

# Export the result
result.val().exportStl("Generated.stl")
