
import cadquery as cq

# Create the U-shaped sketch and extrude it
U_shape = (
    cq.Workplane("XY")
    .moveTo(-0.75, 0)
    .lineTo(0.75, 0)
    .lineTo(0.75, 0.5)
    .lineTo(-0.75, 0.5)
    .close()
    .extrude(0.5)
)

# Create the square sketches and extrude them
square_left = (
    cq.Workplane("XY")
    .moveTo(-1, 0)
    .rect(0.5, 0.5)
    .extrude(0.5)
)

square_right = (
    cq.Workplane("XY")
    .moveTo(1, 0)
    .rect(0.5, 0.5)
    .extrude(0.5)
)

# Combine all the parts
result = U_shape.union(square_left).union(square_right)

# Export the result
result.val().exportStl("Refine_1.stl")
