
import cadquery as cq

# Define the points the polyline will be drawn through
points = [(0, 0), (0, 0.75), (0.75, 0.75), (0.75, 0.67), (0.22, 0.67), (0.22, 0)]

# Create a workplane and draw the polyline
r = cq.Workplane("front").polyline(points)

# Mirror the polyline about the Y axis and extrude it into a 3D object
result = r.mirrorY().extrude(0.75)

# Export the result to STL
result.val().exportStl("Refine_2.stl")
