
import cadquery as cq

# Define the dimensions of the trapezoid
base = 1.05
top = 0.58
height = 0.01

# Create the trapezoid
result = (
    cq.Workplane("front")
    .moveTo(-base / 2.0, 0)
    .lineTo(-top / 2.0, height)
    .lineTo(top / 2.0, height)
    .lineTo(base / 2.0, 0)
    .close()
    .extrude(1.0)  # Extrude the 2D trapezoid into a 3D object
)

# Export the result to STL
result.val().exportStl("Refine_1.stl")
