
import cadquery as cq

# Create a workplane
result = cq.Workplane("XY")

# Create a large annulus shape
result = result.circle(1.5).circle(0.75)

# Extrude the annulus shape
result = result.extrude(0.6)

# Select the bottom face of the cylinder
result = result.faces("<Z").workplane()

# Create a circle at the bottom of the cylinder to close it
result = result.circle(1.5).extrude(0.6)

# Save the output
result.val().exportStl("Refine_1.stl")
