
import cadquery as cq

# Create a workplane
result = cq.Workplane("XY")

# Create a large annulus shape
result = result.circle(3.0).circle(1.5)

# Extrude the annulus shape
result = result.extrude(1.2)

# Select the bottom face of the cylinder
result = result.faces("<Z").workplane()

# Create a circle at the bottom of the cylinder to close it
result = result.circle(3.0).extrude(1.2)

# Save the output
result.val().exportStl("Refine_2.stl")
