
import cadquery as cq

# Define the dimensions
outer_radius = 1.5  # Outer radius of the cylinder
inner_radius = 0.38  # Radius of the small hole
height = 1.5  # Height of the cylinder

# Create the outer cylinder
result = cq.Workplane("XY").circle(outer_radius).extrude(height)

# Create the small hole
result = result.faces(">Z").workplane().circle(inner_radius).cutThruAll()

# Export the result
result.val().exportStl("Refine_1.stl")
